/* ============ */
/* ksinv.c	*/
/* ============ */
#include <math.h>
#include <mconf.h>
#include <miscdefs.h>
#include <stdio.h>
#include <stdlib.h>
/* ==================================================== */
/* LinTrp - Interpolates X0 Linearly in [X1,Y1],[X2,Y2] */
/* ==================================================== */
# if defined(__STDC__) || defined(__PROTO__)
static double
LinTrp(double X0, double X1, double Y1, double X2, double Y2)
# else
static double
LinTrp(X0, X1, Y1, X2, Y2)
double	X0, X1, Y1, X2, Y2;
# endif
{
    return(X1 == X2) ? Y1 : Y1 + (Y2 - Y1) / (X2 - X1) * (X0 - X1);
}
/* ==================================================================== */
/* KSmirInv - Functional inverse of KSmirnov distribution function	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
double
KSmirInv(int n, double p)
# else
double
KSmirInv(n, p)
int	n;
double	p;
# endif
{
    double  e, RetVal;
    double  e0, e1, e2, p0, p1, p2;
    /* ------------------------------------- */
    /* Finds e such that KSmirnov(n, e) = p. */
    /* ------------------------------------- */
    if (p <= 0.0 || p >= 1.0)
    {
	if (p == 0.0)
	{
	    RetVal = 0;
	}
	else if (p == 1.0)
	{
	    RetVal = 1.0;
	}
	else
	{
	    char   *ErrLabel;

	    ErrLabel =
		(p < 0) ? "KSmirInv(): p < 0" : "KSmirInv(): p > 1";

	    mtherr(ErrLabel, DOMAIN);

	    RetVal = -1;
	}
    }
    else
    {
	/* ------------------------------------------------ */
	/* Start with approximation p2 = 1 - exp(-2 n e^2). */
	/* ------------------------------------------------ */
	/* -------------------------------- */
	/* Solve for e2 and Get Estimate p2 */
	/* -------------------------------- */
	e2 = sqrt(-log(1 - p) / (2.0 * n));
	e2 = __min(e2, 1.0);
	p2 = KSmirnov(n, e2);

	/* ------------------------ */
	/* Get Estimate of (e1, p1) */
	/* ------------------------ */
	e1 = .9 * e2;
	e1 = LinTrp(p, KSmirnov(n, e1), e1, p2, e2);
	p1 = KSmirnov(n, e1);

	e0 = LinTrp(p, p1, e1, p2, e2);

	do
	{
	    e = e0;

	    p0 = KSmirnov(n, e0);

	    if (p0 < p)
	    {
		p1 = p0, e1 = e0;
	    }
	    else
	    {
		p2 = p0, e2 = e0;
	    }

	    e0 = LinTrp(p, p1, e1, p2, e2);
	}
	while (fabs(1 - e / e0) > 1e-10);

	RetVal = e0;
    }

    return RetVal;
}
